% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_round.R
\name{pp_round}
\alias{pp_round}
\title{Rounding Function}
\usage{
pp_round(x, tpop, spop, sid)
}
\arguments{
\item{x}{An object of class \code{sf} obtained by the
\link[populR]{pp_estimate} function}

\item{tpop}{Target population estimates obtained by the
\link[populR]{pp_estimate} function}

\item{spop}{Initial source population values (included after the implementation
of the \link[populR]{pp_estimate} function)}

\item{sid}{Source identification number}
}
\value{
An object of class \code{sf} including rounded population counts stored
    in a new column called pp_int
}
\description{
Rounding Function
}
\examples{
# read lib data
data('src')
data('trg')

# areal weighted interpolation - awi
awi <- pp_estimate(trg, src, sid = sid, spop = pop,
    method = awi)

# volume weighted interpolation - vwi
vwi <- pp_estimate(trg, src, sid = sid, spop = pop,
    method = vwi, volume = floors)

# awi - round
pp_round(awi, tpop = pp_est, spop = pop, sid = sid)

# vwi - round
pp_round(vwi, tpop = pp_est, spop = pop, sid = sid)

}
