% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Penalty.matrix.R
\name{Penalty.matrix}
\alias{Penalty.matrix}
\title{Penalty Matrix for Higher Order Differences}
\usage{
Penalty.matrix(m, order = 2)
}
\arguments{
\item{m}{Numeric vector indicating sizes of blocks.}

\item{order}{Integer indicating the order of differences (default is 2).}
}
\value{
Penalty matrix (numeric matrix) of dimension \code{sum(m)} x \code{sum(m)}.
}
\description{
Computes the block-diagonal penalty matrix penalizing higher-order differences.
}
\details{
For each block of size \code{m[j]}, and default \code{order = 2}, computes:
\deqn{v^\top P_j v = \sum_{i=3}^{m[j]} (v_i - 2v_{i-1} + v_{i-2})^2.}
The final penalty matrix is block-diagonal composed of blocks \eqn{P_j}.
}
\examples{
P <- Penalty.matrix(c(6, 4), order = 2)

}
\references{
Kraemer, N., Boulesteix, A.-L., & Tutz, G. (2008). Penalized Partial Least Squares with Applications to B-Spline Transformations and Functional Data. \emph{Chemometrics and Intelligent Laboratory Systems}, 94, 60-69. https://doi.org/10.1016/j.chemolab.2008.06.009
}
