% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic.ppls.splines.R
\name{graphic.ppls.splines}
\alias{graphic.ppls.splines}
\title{Plot Penalized PLS Components for Spline-Transformed Data}
\usage{
graphic.ppls.splines(
  X,
  y,
  lambda = NULL,
  add.data = FALSE,
  select = FALSE,
  ncomp = 1,
  deg = 3,
  order = 2,
  nknot = NULL,
  reduce.knots = FALSE,
  kernel = TRUE,
  window.size = c(3, 3)
)
}
\arguments{
\item{X}{A numeric matrix of input data.}

\item{y}{A numeric response vector.}

\item{lambda}{A numeric value for the penalization parameter. Default is \code{NULL}.}

\item{add.data}{Logical. If \code{TRUE}, the original data points \code{X} and \code{y} are added to the plots. Default is \code{FALSE}.}

\item{select}{Logical. If \code{TRUE}, the function fits only one block (variable) per iteration (block-wise selection). Default is \code{FALSE}.}

\item{ncomp}{Integer. Number of PLS components to use. Default is 1.}

\item{deg}{Integer. Degree of the B-spline basis. Default is 3.}

\item{order}{Integer. Order of the differences to penalize. Default is 2.}

\item{nknot}{A numeric vector specifying the number of knots for each variable. Default is \code{NULL}, which uses \code{rep(20, ncol(X))}.}

\item{reduce.knots}{Logical. If \code{TRUE}, automatically reduces the number of knots for variables leading to constant basis functions. Default is \code{FALSE}.}

\item{kernel}{Logical. If \code{TRUE}, uses the kernelized version of PPLS. Default is \code{TRUE}.}

\item{window.size}{A numeric vector of length 2 indicating the number of plots per row and column. Default is \code{c(3, 3)} (3 rows and 3 columns).}
}
\value{
A numeric vector of regression coefficients for the final penalized PLS model.
}
\description{
This function applies a nonlinear regression model using penalized Partial Least Squares (PLS) on B-spline transformed variables, then visualizes each additive component.
}
\details{
This function first transforms the input data \code{X} and a test grid \code{Xtest} using B-spline basis functions, then fits a penalized PLS model using these transformed variables.
Each additive component (i.e., variable effect) is then plotted individually.

If \code{add.data = TRUE}, the actual observations are plotted on top of the corresponding fitted component functions. While this can help visualize the fit, note that only the sum of all fitted components approximates \code{y}, and not each component individually.

The function is intended for exploratory visualization and should be used after appropriate model selection using, e.g., \code{\link{ppls.splines.cv}}.
}
\examples{
# Load Boston housing data
library(MASS)
data(Boston)
y <- Boston[, 14]
X <- Boston[, -14]
X <- X[, -4]  # remove categorical variable
X <- as.matrix(X)

# Plot with variable selection and original data
graphic.ppls.splines(
  X, y, lambda = 100, ncomp = 5,
  add.data = TRUE, select = TRUE, window.size = c(3, 4)
)

# Plot without variable selection and without data
graphic.ppls.splines(
  X, y, lambda = 100, ncomp = 5,
  add.data = FALSE, select = FALSE, window.size = c(3, 4)
)

}
\references{
N. Kraemer, A.-L. Boulesteix, and G. Tutz (2008). \emph{Penalized Partial Least Squares with Applications to B-Spline Transformations and Functional Data}. Chemometrics and Intelligent Laboratory Systems, 94(1), 60–69. \doi{10.1016/j.chemolab.2008.06.009}
}
\seealso{
\code{\link{ppls.splines.cv}}, \code{\link{X2s}}, \code{\link{penalized.pls}}, \code{\link{Penalty.matrix}}
}
