% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_boot_propmean_se.R
\name{gen_boot_propmean_se}
\alias{gen_boot_propmean_se}
\title{Descriptive statistics for bootstrapped lineup proportion}
\usage{
gen_boot_propmean_se(lineuprops)
}
\arguments{
\item{lineuprops}{A dataframe of bootstrapped lineup proportions}
}
\value{
Mean, median, standard deviation, standard error & 95 CIs of
       lineup proportion across a bootstrapped dataframe
}
\description{
Function for computing mean. med and se of boot proportion
}
\examples{
#Data:
lineup_vec <- round(runif(100, 1, 6))
target_pos <- 3

#Bootstrap data:
lineup_boot_df <- gen_boot_samples(lineup_vec, 1000)

#Compute proportion for bootstrap samples:
lineuprops <- gen_lineup_prop(lineup_boot_df, target_pos = 3, k = 6)

#Call:
gen_boot_propmean_se(lineuprops)

#OR:

lineuprops <- boot::boot(lineup_vec, lineup_prop_boot, target_pos = 3, R = 1000)
gen_boot_propmean_se(lineuprops$t)
}
