% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rCoinBase.R
\name{cb_candles}
\alias{cb_candles}
\title{Get OHLCV Bars (long-term)}
\usage{
cb_candles(product_id, start, end, bar_size)
}
\arguments{
\item{product_id}{= The trading pair (e.g. 'BTC-USD').}

\item{start}{= start date to get data. Ex. Sys.Date()-60}

\item{end}{= End date to get data. Ex. Sys.Date()}

\item{bar_size}{= The timeframe each candle represents. Examples: ONE_MINUTE, FIVE_MINUTE, FIFTEEN_MINUTE, THIRTY_MINUTE, ONE_HOUR, TWO_HOUR, SIX_HOUR, ONE_DAY}
}
\value{
Get a \code{data.frame} with rates for a single product by product ID, grouped in buckets for more than 350 bars.
}
\description{
Get OHLCV Bars (long-term)
}
\examples{
\dontrun{
  cb_candles(product_id="BTC-USD", start=Sys.Date()-30, end=Sys.Date(),
             bar_size= "FIFTEEN_MINUTE")
}
}
