% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installation.R
\name{dockerize}
\alias{dockerize}
\alias{dockerize_rang}
\alias{dockerise}
\alias{dockerise_rang}
\title{Dockerize The Resolved Result}
\usage{
dockerize(
  rang,
  output_dir,
  materials_dir = NULL,
  post_installation_steps = NULL,
  image = c("r-ver", "rstudio", "tidyverse", "verse", "geospatial"),
  rang_as_comment = TRUE,
  cache = FALSE,
  verbose = TRUE,
  lib = NA,
  cran_mirror = "https://cran.r-project.org/",
  check_cran_mirror = TRUE,
  bioc_mirror = "https://bioconductor.org/packages/",
  no_rocker = FALSE,
  debian_version = c("lenny", "squeeze", "wheezy", "jessie", "stretch"),
  skip_r17 = TRUE,
  insert_readme = TRUE,
  copy_all = FALSE
)

dockerize_rang(...)

dockerise(...)

dockerise_rang(...)
}
\arguments{
\item{rang}{output from \code{\link[=resolve]{resolve()}}}

\item{output_dir}{character, where to put the Docker file and associated content}

\item{materials_dir}{character, path to the directory containing additional resources (e.g. analysis scripts) to be copied into \code{output_dir} and in turn into the Docker container}

\item{post_installation_steps}{character, additional steps to be added before the \code{CMD} part of the Dockerfile, see an example below}

\item{image}{character, which versioned Rocker image to use. Can only be "r-ver", "rstudio", "tidyverse", "verse", "geospatial"
This applies only to R version >= 3.1}

\item{rang_as_comment}{logical, whether to write resolved result and the steps to reproduce
the file to \code{path} as comment}

\item{cache}{logical, whether to cache the packages now. Please note that the system requirements are not cached. For query with non-CRAN packages, this option is strongly recommended. For query with local packages, this must be TRUE regardless of R version. For R version < 3.1, this must be also TRUE if there is any non-CRAN packages.}

\item{verbose}{logical, pass to \code{\link[=install.packages]{install.packages()}}, the negated value is also passed as \code{quiet} to both \code{\link[=install.packages]{install.packages()}}
and \code{\link[=download.file]{download.file()}}.}

\item{lib}{character, pass to \code{\link[=install.packages]{install.packages()}}. By default, it is NA (to install the packages to the default location)}

\item{cran_mirror}{character, which CRAN mirror to use}

\item{check_cran_mirror}{logical, whether to check the CRAN mirror}

\item{bioc_mirror}{character, which Bioconductor mirror to use}

\item{no_rocker}{logical, whether to skip using Rocker images even when an appropriate version is available. Please keep this as \code{TRUE} unless you know what you are doing}

\item{debian_version}{when Rocker images are not used, which EOL version of Debian to use. Can only be "lenny", "etch", "squeeze", "wheezy", "jessie", "stretch". Please keep this as default "lenny" unless you know what you are doing}

\item{skip_r17}{logical, whether to skip R 1.7.x. Currently, it is not possible to compile R 1.7.x (R 1.7.0 and R 1.7.1) with the method provided by  \code{rang}. It affects \code{snapshot_date} from 2003-04-16 to 2003-10-07. When \code{skip_r17} is TRUE and \code{snapshot_date} is within the aforementioned range, R 1.8.0 is used instead}

\item{insert_readme}{logical, whether to insert a README file}

\item{copy_all}{logical, whether to copy everything in the current directory into the container. If \code{inst/rang} is detected in \code{output_dir}, this is coerced to TRUE.}

\item{...}{arguments to be passed to \code{dockerize}}
}
\value{
\code{output_dir}, invisibly
}
\description{
This function exports the result from \code{\link[=resolve]{resolve()}} to a Docker file. For R version >= 3.1.0, the Dockerfile is based on the versioned Rocker image.
For R version < 3.1.0, the Dockerfile is based on Debian and it compiles R from source.
}
\details{
The idea behind this is to determine the installation order of R packages locally. Then, the installation script can be deployed to another
fresh R session to install R packages. \code{\link[=dockerize]{dockerize()}} and \code{\link[=apptainerize]{apptainerize()}} are more reasonable ways because a fresh R session with all system requirements
is provided. The current approach does not work in R < 2.1.0.
}
\examples{
\donttest{
if (interactive()) {
    graph <- resolve(pkgs = c("openNLP", "LDAvis", "topicmodels", "quanteda"),
                    snapshot_date = "2020-01-16")
    dockerize(graph, ".")
    ## An example of using post_installation_steps to install quarto
    install_quarto <- c("RUN apt-get install -y curl git && \\\\
    curl -LO https://quarto.org/download/latest/quarto-linux-amd64.deb && \\\\
    dpkg -i quarto-linux-amd64.deb && \\\\
    quarto install tool tinytex")
    dockerize(graph, ".", post_installation_steps = install_quarto)
}
}
}
\references{
\href{https://rocker-project.org}{The Rocker Project}
Ripley, B. (2005) \href{https://cran.r-project.org/doc/Rnews/Rnews_2005-1.pdf}{Packages and their Management in R 2.1.0.} R News, 5(1):8--11.
}
\seealso{
\code{\link[=resolve]{resolve()}}, \code{\link[=export_rang]{export_rang()}}, \code{\link[=use_rang]{use_rang()}}
}
