% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math-collapse_arrays.R
\name{collapse_power}
\alias{collapse_power}
\alias{collapse_power.array}
\alias{collapse_power.FileArray}
\title{Collapse power array with given analysis cubes}
\usage{
collapse_power(x, analysis_index_cubes)

\method{collapse_power}{array}(x, analysis_index_cubes)

\method{collapse_power}{FileArray}(x, analysis_index_cubes)
}
\arguments{
\item{x}{a \code{\link[filearray]{FileArray-class}} array, must have 4 modes
in the following sequence \code{Frequency}, \code{Time}, \code{Trial},
and \code{Electrode}}

\item{analysis_index_cubes}{a list of analysis indices for each mode}
}
\value{
a list of collapsed (mean) results
\describe{
\item{\code{freq_trial_elec}}{collapsed over time-points}
\item{\code{freq_time_elec}}{collapsed over trials}
\item{\code{time_trial_elec}}{collapsed over frequencies}
\item{\code{freq_time}}{collapsed over trials and electrodes}
\item{\code{freq_elec}}{collapsed over trials and time-points}
\item{\code{freq_trial}}{collapsed over time-points and electrodes}
\item{\code{time_trial}}{collapsed over frequencies and electrodes}
\item{\code{time_elec}}{collapsed over frequencies and trials}
\item{\code{trial_elec}}{collapsed over frequencies and time-points}
\item{\code{freq}}{power per frequency, averaged over other modes}
\item{\code{time}}{power per time-point, averaged over other modes}
\item{\code{trial}}{power per trial, averaged over other modes}
}
}
\description{
Collapse power array with given analysis cubes
}
\examples{


# Generate a 4-mode tensor array
x <- filearray::filearray_create(
  tempfile(), dimension = c(16, 100, 20, 5),
  partition_size = 1
)
x[] <- rnorm(160000)
dnames <- list(
  Frequency = 1:16,
  Time = seq(0, 1, length.out = 100),
  Trial = 1:20,
  Electrode = 1:5
)
dimnames(x) <- dnames

# Collapse array
results <- collapse_power(x, list(
  overall = list(),
  A = list(Trial = 1:5, Frequency = 1:6),
  B = list(Trial = 6:10, Time = 1:50)
))

# Plot power over frequency and time
groupB_result <- results$B


image(t(groupB_result$freq_time),
      x = dnames$Time[groupB_result$cube_index$Time],
      y = dnames$Frequency[groupB_result$cube_index$Frequency],
      xlab = "Time (s)",
      ylab = "Frequency (Hz)",
      xlim = range(dnames$Time))

x$delete(force = TRUE)


}
