% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdataretriever.R
\name{download}
\alias{download}
\title{Download datasets via the Data Retriever.}
\usage{
download(
  dataset,
  path = "./",
  quiet = FALSE,
  sub_dir = "",
  debug = FALSE,
  use_cache = TRUE
)
}
\arguments{
\item{dataset}{the name of the dataset that you wish to download}

\item{path}{the path where the data should be downloaded to}

\item{quiet}{logical, if true retriever runs in quiet mode}

\item{sub_dir}{downloaded dataset is stored into a custom subdirectory.}

\item{debug}{setting TRUE helps in debugging in case of errors}

\item{use_cache}{Setting FALSE reinstalls scripts even if they are already installed}
}
\value{
No return value, downloads the raw dataset
}
\description{
Directly downloads data files with no processing, allowing downloading of
non-tabular data.
}
\examples{
\dontrun{
rdataretriever::download("plant-comp-ok")
# downloaded files will be copied to your working directory
# when no path is specified
dir()
}
}
