% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessors.R
\name{failstop}
\alias{failstop}
\title{Example Test Result Postprocessors}
\usage{
failstop(r)
}
\arguments{
\item{r}{object of class \code{realtest_result}, see \code{\link{E}}}
}
\value{
Returns \code{r}, invisibly.
}
\description{
Generally, test result postprocessors are used by the \code{\link{E}}
function. \code{failstop} calls \code{\link[utils]{str}(r)}
and throws an error if an expectation is not met, i.e.,
when \code{r[["matches"]]} is of length 0.
}
\details{
These are example postprocessors. You are encouraged to write your
own ones that will suit your own needs. Explore their source code
for some inspirations. It's an open source (and free!) project after all.

For \code{failstop}, you can always create a function
\code{str.realtest_result} implementing the pretty printing of an error
message.
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
\seealso{
The official online manual of \pkg{realtest} at \url{https://realtest.gagolewski.com/}
}
