% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calculateNullESAccuracy}
\alias{calculateNullESAccuracy}
\title{calculateNullESAccuracy}
\usage{
calculateNullESAccuracy(
  mean = 0,
  sd = 1,
  N = 10,
  reps = 10,
  type = "n",
  seed = 123,
  StdAdj = 0,
  Blockmean = 0.5
)
}
\arguments{
\item{mean}{The mean of the baseline distribution.}

\item{sd}{The standard deviation or shape of the baseline distribution}

\item{N}{The number of observations per group for two group experiments and N/2 the sample sizes for four group experiments. N must be even to ensure equal N/2 defines appropriate sample sizes per group for 4 group experiments}

\item{reps}{The number of replications (i.e. two-group and four group experiments) to be simulated}

\item{type}{A string parameter defining the distribution being simulated i.e. 'n' for normal data, 'l' for log-normal data, 'g' for gamma data and 'lap' for LaPlace data.}

\item{seed}{A starting value for the simulations}

\item{StdAdj}{A numerical parameter that can be used to add additional variance for normal, lognormal and Laplce data and to change the shape parameter for gamma data.}

\item{Blockmean}{A numerical parameter used to introduce a fixed Block effect for four group experiments}
}
\value{
A tibble identifying the median absolute error for the effect sizes Cliff's d, phat and StdMD and the Type 1 error rate, estimated from the proportion of significant effect sizes in the simulated experiments.
}
\description{
The function uses simulation to assess the accuracy when the mean difference is zero, and the type 1 error rates of parametric and non-parametric effect sizes for both two group randomized designs and four group randomized block designs, for each of four different distributions.
}
\examples{
as.data.frame(
  calculateNullESAccuracy(
    mean=0,sd=1,N=10,reps=30,type='n',seed=123,StdAdj = 0,Blockmean = 0.5))
#   Design Obs CliffdAbsError PHatAbsError StdESdAbsError  varCliffd    varPHat
# 1   2G_n  20           0.20         0.10      0.2624447 0.05530851 0.01382713
# 2   4G_n  20           0.16         0.08      0.1848894 0.05447540 0.01361885
#    varStdES    ObsCliffd   ObsPHat     ObsStdES CliffdType1ER PHatType1ER
# 1 0.1425374  0.021333333 0.5106667 0.0001190251             0           0
# 2 0.1484728 -0.009333333 0.4953333 0.0295002335             0           0
#   StdESType1ER
# 1   0.03333333
# 2   0.03333333
#as.data.frame(
 # calculateNullESAccuracy(
 #   mean=0,sd=1,N=10,reps=100,type='n',seed=123,StdAdj = 0,Blockmean = 0.5))
#  Design Obs CliffdAbsError PHatAbsError StdESdAbsError  varCliffd    varPHat  varStdES ObsCliffd
#1   2G_n  20           0.21        0.105      0.3303331 0.08064949 0.02016237 0.2488365   -0.0010
#2   4G_n  20           0.16        0.080      0.2565372 0.05933430 0.01483358 0.1769521    0.0052
#  ObsPHat    ObsStdES CliffdType1ER PHatType1ER StdESType1ER
#1  0.4995 -0.02395895          0.07        0.08         0.08
#2  0.5026  0.03769940          0.01        0.01         0.02
}
\author{
Barbara Kitchenham and Lech Madeyski
}
