% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_field.R
\name{metric_field}
\alias{metric_field}
\title{Create a metric tensor field}
\usage{
metric_field(metric, metric_inv, coords)
}
\arguments{
\item{metric}{A \code{nxn} matrix / array representing the covariant metric tensor components.
The components are usually expressions as character strings formed from
coordinates, since numeric values can only represent constant tensor fields.}

\item{metric_inv}{A \code{nxn} matrix / array representing the contraviant metric tensor components,
i.e. the inverse matrix of the covariant metric tensor component matrix.}

\item{coords}{A character vector of \code{n} coordinate names that are used in the component
expressions. This information is essential for forming symbolic derivatives.}
}
\value{
An object of class \code{c("metric_field", "array")} that represents the
components of a metric tensor on a (Pseudo-) Riemannian manifold in a
certain coordinate system specified by \code{coords}.
}
\description{
Metric tensors are an essential ingredient of (Pseudo-) Riemannian
manifolds and define distance relations between points.
They are used to define geometric tensors such as e.g. the Ricci curvature
\code{\link[=ricci]{ricci()}}, and a metric connection, i.e. a covariant derivative.
They are also essential for raising and lowering indices of tensor fields
correctly when using non-flat coordinates.
}
\seealso{
Wikipedia: \href{https://en.wikipedia.org/wiki/Metric_tensor}{Metric tensor}

Other metric tensors: 
\code{\link{g_eucl_cart}()},
\code{\link{g_mink_cart}()},
\code{\link{g_sph}()},
\code{\link{g_ss}()}
}
\concept{metric tensors}
\concept{metric_tensors}
