% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splayer.R
\name{spLayerControl}
\alias{spLayerControl}
\title{Testing user inputs}
\usage{
spLayerControl(
  name,
  size = 1,
  legend = legend,
  stroke = TRUE,
  stroke.col = 1,
  stroke.lwd = 1,
  stroke.lty = 1,
  stroke.alpha = 1,
  fill = TRUE,
  fill.col = 1,
  fill.alpha = 1,
  label = "",
  popup = "",
  holes = FALSE
)
}
\arguments{
\item{name}{a character string to name the layer.}

\item{size}{a numerical vector giving the size of points (radius in pixels).}

\item{legend}{a legend object created with \code{\link{layerLegend}}.}

\item{stroke}{logical. Should a stroke be drawn along lines and polygons?}

\item{stroke.col}{a vector of any of the three kinds of \R color specifications to set strokes color.}

\item{stroke.lwd}{a numerical vector to set strokes width.}

\item{stroke.lty}{a character vector that defines the strokes dash patterns (See Details).}

\item{stroke.alpha}{a vector of numeric values in \eqn{[0, 1]} setting strokes opacity.}

\item{fill}{logical. Should points and polygons be filled?}

\item{fill.col}{a vector of any of the three kinds of \R color specifications to set fill colors.}

\item{fill.alpha}{a vector of numeric values in \eqn{[0, 1]} setting fill opacity.}

\item{label}{a reserved argument (in development).}

\item{popup}{a character vector giving contents for popups. HTML tags are accepted.}

\item{holes}{a logical indicating whether to use the \code{hole} slots of the \code{SpatialPolygons} object.}
}
\description{
This function tests arguments validity for the function \code{\link{spLayer}}.
}
