% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hamiltonian.R
\name{log_density_ratio_hamiltonian}
\alias{log_density_ratio_hamiltonian}
\title{Compute logarithm of Hamiltonian proposal density ratio.}
\usage{
log_density_ratio_hamiltonian(
  state,
  proposed_state,
  target_distribution,
  scale_and_shape
)
}
\arguments{
\item{state}{Current chain state.}

\item{proposed_state}{Proposed chain state.}

\item{target_distribution}{Target stationary distribution for chain. A list
with named entries \code{log_density} and \code{gradient_log_density} corresponding to
respectively functions for evaluating the logarithm of the (potentially
unnormalized) density of the target distribution and its gradient.
As an alternative to \code{gradient_log_density} an entry
\code{value_and_gradient_log_density} may instead be provided which is a function
returning both the value and gradient of the logarithm of the (unnormalized)
density of the target distribution as a list under the names \code{value} and
\code{gradient} respectively.}

\item{scale_and_shape}{Scalar, vector or matrix which scales and shapes
proposal distribution. If a scalar (in which case the value should be
non-negative) the auxiliary vector will be isotropically scaled by the
value. If a vector (in which case the value should be equal in length to the
dimension of the space and all entries non-negative) each dimension of the
auxiliary vector will be scaled separately. If a matrix (in which case the
value should be a square matrix with size equal to the dimension of the
space) then by pre-multiplying the auxiliary vector arbitrary linear
transformations can be performed.}
}
\value{
Logarithm of proposal density ratio.
}
\description{
Compute logarithm of Hamiltonian proposal density ratio.
}
\keyword{internal}
