% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_2plots.R
\name{add_2plots}
\alias{add_2plots}
\title{Add two plots into a document object}
\usage{
add_2plots(
  mydoc,
  plotstring1,
  plotstring2,
  plottype = "auto",
  width = NULL,
  height = NULL,
  echo = FALSE,
  top = 2
)
}
\arguments{
\item{mydoc}{A document object}

\item{plotstring1}{An R code string encoding the first plot}

\item{plotstring2}{An R code string encoding the second plot}

\item{plottype}{character  One of c("auto","plot","ggplot")}

\item{width}{plot width in inches}

\item{height}{plot height in inches}

\item{echo}{logical Whether or not show R code}

\item{top}{top plot position in inches}
}
\value{
a document object
}
\description{
Add two plots into a document object
}
\examples{
require(magrittr)
require(officer)
require(ggplot2)
plotstring1="plot(iris)"
plotstring2="ggplot(iris,aes(x=Sepal.Length,y=Sepal.Width))+geom_point()"
read_pptx() \%>\% add_text(title="Two plots") \%>\% add_2plots(plotstring1,plotstring2)
read_docx() \%>\% add_text(title="Two plots") \%>\% add_2plots(plotstring1,plotstring2)
}
