% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerBAFReader.R
\name{getBrukerBAFAllMetadata}
\alias{getBrukerBAFAllMetadata}
\title{Retrieve all metadata values from a Bruker BAF file}
\usage{
getBrukerBAFAllMetadata(reader)
}
\arguments{
\item{reader}{An RTMS reader object of class \code{rtmsBrukerBAFReader}}
}
\value{
A data frame with all metadata parameters for the acquisition. The
data frame will have five columns: \code{rowIndex}, a numeric index for each
metadata value; \code{parameterName}, the internal identifier of the parameter in
Bruker software systems; \code{parameterGroup}, the group of parameters that each
value belongs to; \code{displayName}, the string used to specify the parameter to
users (i.e. how the parameter would be labelled in a user interface); and
\code{stringValue}, a character column containing the value of each metadata
parameter.  Numeric quantities will also be returned as strings, with units
if appropriate.
}
\description{
Retrieves a table of all metadata values (including instrument data,
acquisition parameters, processing and analysis directives, etc.) from a
Bruker single acquisition BAF directory (represented by an
\code{rtmsBrukerBAFReader} object).
}
