% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerBAFReader.R
\name{getSample.rtmsBrukerBAFReader}
\alias{getSample.rtmsBrukerBAFReader}
\alias{getBrukerBAFSample}
\title{Extract a sample from a Bruker BAF directory}
\usage{
\method{getSample}{rtmsBrukerBAFReader}(x, peaks, ...)

getBrukerBAFSample(reader, peaks)
}
\arguments{
\item{x}{The BAF reader object}

\item{peaks}{A list of peak objects of class \code{rtmsPeak}}

\item{...}{Additional parameters}

\item{reader}{An RTMS reader object of class \code{rtmsBrukerBAFReader}}
}
\value{
An RTMS sample object of class \code{rtmsSample}
}
\description{
Extracts an RTMS sample object (of class \code{rtmsSample}) from a single
acquisition Bruker BAF directory opened using an RTMS reader object (of
class \code{rtmsBrukerBAFReader}).  Because a BAF directory only contains one
spectrum, no additional parameters are needed to specify the spectrum from
which to take the sample.
}
\section{Functions}{
\itemize{
\item \code{getSample(rtmsBrukerBAFReader)}: The S3 method \code{getSample} for objects
of class \code{rtmsBrukerBAFReader}; calls \code{getBrukerBAFSample}

}}
