% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_lavaan_rerun.R
\name{print.lavaan_rerun}
\alias{print.lavaan_rerun}
\title{Print Method for 'lavaan_rerun'}
\usage{
\method{print}{lavaan_rerun}(x, ...)
}
\arguments{
\item{x}{The output of \code{\link[=lavaan_rerun]{lavaan_rerun()}}.}

\item{...}{Other arguments. They will be ignored.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Prints the results of \code{\link[=lavaan_rerun]{lavaan_rerun()}}.
}
\examples{
library(lavaan)
dat <- pa_dat
# For illustration only, select only the first 50 cases
dat <- dat[1:50, ]
# The model
mod <-
"
m1 ~ iv1 + iv2
dv ~ m1
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)
# Fit the model n times. Each time with one case removed.
fit_rerun <- lavaan_rerun(fit, parallel = FALSE)
fit_rerun

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
