% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_semlbci.R
\name{confint.semlbci}
\alias{confint.semlbci}
\title{Confidence Intervals for a 'smelbci' Object}
\usage{
\method{confint}{semlbci}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{The output of \code{\link[=semlbci]{semlbci()}}.}

\item{parm}{The parameters for which the confidence
intervals are returned. Not used because parameters
are defined by three or more columns (\code{lhs}, \code{op},
\code{rhs}, and \code{group} for multisample models).}

\item{level}{Ignored. The level of confidence is determined
when calling \code{\link[=semlbci]{semlbci()}} and cannot be changed.}

\item{...}{Optional arguments. Ignored.}
}
\value{
A two-column matrix of the confidence intervals.
}
\description{
Return the confidence intervals of the parameters
in the output of \code{\link[=semlbci]{semlbci()}}.
}
\details{
It returns the likelihood-based confidence intervals
in the output of \code{\link[=semlbci]{semlbci()}}.
}
\examples{


library(lavaan)
mod <-
"
m ~ a*x
y ~ b*m
ab := a * b
"
fit_med <- sem(mod, simple_med, fixed.x = FALSE)
p_table <- parameterTable(fit_med)
p_table
lbci_med <- semlbci(fit_med,
                    pars = "ab :=")
lbci_med

confint(lbci_med)

}
\seealso{
\code{\link[=semlbci]{semlbci()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
