% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_instrument.R
\name{play.instrument}
\alias{play.instrument}
\title{Play an instrument}
\usage{
play.instrument(
  inst,
  notes = 1:length(inst),
  time = seq(0, (length(notes) - 1) * 0.25, length.out = length(notes)),
  volume = rep(1, length(notes)),
  pan = rep(0, length(notes)),
  fadein = rep(0.01, length(notes)),
  fadeout = fadein,
  env = NULL,
  nmax = 10 * 10^6
)
}
\arguments{
\item{inst}{Instrument object.}

\item{notes}{String or integer vector, the notes of the instrument to be played,
either by name or by index.}

\item{time}{Numeric vector, time (in seconds) at which each note should be played.
Should be non-negative, non-decreasing and have same size as notes.}

\item{volume}{Numeric vector, volume between 0 and 1,}

\item{pan}{Numeric vector, pan between -1 (left) and 1 (right) (0 = centered).
Same size as notes.}

\item{fadein}{Numeric vector, fade-in duration (in seconds), same size as notes.}

\item{fadeout}{Numeric vector, fade-out duration (in seconds), same size as notes.
Use Inf for 'let ring'.}

\item{env}{list of envelope objects, envelope applied to each note.}

\item{nmax}{Integer, max number of values for each channel of the resulting Wave.
Default value (10*10^6) roughly corresponds to a 150 Mb stereo wave, ~3 min 45s.}
}
\value{
an S4 Wave object (from package tuneR).
}
\description{
Take a sound sample and repeat it following given timeline,
volume and pan.
}
\examples{
# Create an instrument
samples=list(oscillator(freq=110),oscillator(freq=220),oscillator(freq=261.63),
             oscillator(freq=293.66),oscillator(freq=392))
notes=c('A2','A3','C4','D4','G4')
onTheMoon <- instrument(samples,notes)
# Play it
w=play.instrument(onTheMoon)
# View the result
tuneR::plot(w)
\dontrun{
# This line of code is wrapped in \dontrun{} since it relies
# on an external audio player to play the audio sample.
# See ?tuneR::setWavPlayer for setting a default player.
tuneR::play(w)}
# Use options
w=play.instrument(onTheMoon,time=c(0,0.2,0.4,0.6,0.8,0.9),
                  notes=c('A2','G4','D4','C4','A3','A2'),
                  volume=seq(0.2,1,length.out=6),pan=c(0,-1,1,-1,1,0),
                  fadeout=c(Inf,0.01,0.01,0.01,Inf,Inf))
# View the result
tuneR::plot(w)
\dontrun{
# This line of code is wrapped in \dontrun{} since it relies
# on an external audio player to play the audio sample.
# See ?tuneR::setWavPlayer for setting a default player.
tuneR::play(w)}
}
