% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{betaGetShapes}
\alias{betaGetShapes}
\title{Convert beta mean and precision parameters to two shape parameters}
\usage{
betaGetShapes(mean, precision)
}
\arguments{
\item{mean}{The mean of a beta distribution}

\item{precision}{The precision parameter (phi) of a beta distribution}
}
\value{
A list that includes the shape parameters of the beta distribution
}
\description{
Convert beta mean and precision parameters to two shape parameters
}
\details{
In simstudy, users specify the beta distribution as a function of
two parameters - a mean and precision, where 0 < mean < 1 and precision > 0.
In this case, the variance of the specified distribution is
(mean)*(1-mean)/(1+precision). The base R function rbeta uses the two shape
parameters to specify the beta distribution. This function converts the mean
and precision into the shape1 and shape2 parameters.
}
\examples{
set.seed(12345)
mean <- 0.3
precision <- 1.6
rs <- betaGetShapes(mean, precision)
c(rs$shape1, rs$shape2)
vec <- rbeta(1000, shape1 = rs$shape1, shape2 = rs$shape2)
(estMoments <- c(mean(vec), var(vec)))
(theoryMoments <- c(mean, mean * (1 - mean) / (1 + precision)))
(theoryMoments <- with(rs, c(
  shape1 / (shape1 + shape2),
  (shape1 * shape2) / ((shape1 + shape2)^2 * (1 + shape1 + shape2))
)))
}
\concept{utility}
