% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourPlot2.R
\name{contourPlot2}
\alias{contourPlot2}
\title{Contour Plot of pollutant concentration field}
\usage{
contourPlot2(
  data,
  x = "x",
  y = "y",
  z = "z",
  domain = NULL,
  background = NULL,
  underlayer = NULL,
  overlayer = NULL,
  legend = NULL,
  levels = NULL,
  size = 0,
  fill = TRUE,
  tile = FALSE,
  transparency = 0.75,
  colors = NULL,
  mask = NULL,
  inverse_mask = FALSE,
  bare = FALSE
)
}
\arguments{
\item{data}{A dataframe in long format with three columns for Easting,
Northing and values to be plotted.}

\item{x}{charactrer. Name of the column containing Easting (longitude)
coordinates (default "x").}

\item{y}{character. Name of the column containing Northing (latitude)
coordinates (default "y").}

\item{z}{character. Name of the column containing concentration values
(default "z").}

\item{domain}{optional list of six numeric values defining the
boundaries of the domain to be plotted (minimum X, maximum X, minimum Y,
maximum Y) and the number of ticks on X & Y axis.
Example: c(340000, 346000, 4989500, 4995500, 5, 5).
If missing, all the full domain of the input data is considered, with 5 ticks.}

\item{background}{filename. Optional path to a raster file to be plotted as
the basemap.}

\item{underlayer}{optional list of layers to be plotted between base map
and contour plot. See Details}

\item{overlayer}{optional list of layers to be plotted on top of the contour
plot. See Details.}

\item{legend}{character. Optional title of the legend.}

\item{levels}{numeric vector of levels for contour plot. If not set,
automatic pretty levels are computed. If \code{-Inf} and \code{Inf} are used
as the lowest and highest limits of the array, the lowest and highest bands
are unbounded and the legend shows \code{<} and \code{>=} symbols.}

\item{size}{numeric. Width of the contour line.}

\item{fill}{logical. If TRUE the contour plot is filled with colour (default = TRUE).}

\item{tile}{logical. If TRUE rectangular tiles are plotted (default = FALSE).}

\item{transparency}{transparency level of the contour plot between 0.0
(fully transparent) and 1.0 (fully opaque). Default = 0.75).}

\item{colors}{colour palette for contour plot, as an array of colours.}

\item{mask}{character. Path to \emph{shp} file used as a mask. It must be a closed polygon.}

\item{inverse_mask}{logical. If \code{TRUE} areas on mask are masked. Default is
to mask areas outside the polygon defined in the \emph{shp} file.}

\item{bare}{boolean (default FALSE). If TRUE only the bare plot is shown:
axis, legend, titles and any other graphical element of the plot are removed.}
}
\value{
A \code{ggplot2} object.
}
\description{
The function \code{contourPlot2} generates a contour plot of a given quantity,
such as the ground concentration of an airborne pollutant or odour, defined on a
regular grid.
}
\details{
This is a convenience function to plot contour levels of a scalar quantity
such as pollutants computed by a dispersion model, with \code{ggplot2}
version >= 3.3.0.

Data are required to be on a regular grid, typically (but not necessarily)
in UTM coordinates. The input dataframe has to be in long format, i.e. one
line per value to be plotted. The names of the columns corresponding to \code{x},
\code{y} and \code{z} can be specified in the input parameters.

If \code{tile = TRUE} data are shown as they are, without any graphical
interpolation required for contour plots. This is helpful when you want to
visualise the raw data.
Since version 2.4.0, when \code{tile = TRUE} the intervals include the lowest
bound and exclude the highest bound: \verb{[min, max)}. Note: In previous version
it was the opposite.

\code{underlayer} and \code{overlayer} layers are \code{ggplot2} objects to be shown at
different levels of the vertical stack of the plot. These are useful to
show topographical information related to the plot, such as sources
or receptors locations.

When a \emph{shp} file is given to the \code{mask} argument the plot is drawn only
inside the polygon. In order to avoid boundary artifacts due to reduced
resolution, original data are resampled to higher resolution (currently
set to 10 times the original one.) If\code{inverse_mask} is set to \code{TRUE}, the plot
is drawn outside  the polygon. The \emph{mask} feature is based on the
\code{\link[terra:mask]{terra::mask()}} function.
The CRS of the \emph{shp} file is applied to the data in the data.frame.
Please, keep in mind this feature is still experimental.
}
\examples{
# Load example data in long format
data(volcano)
volcano3d <- reshape2::melt(volcano)
names(volcano3d) <- c("x", "y", "z")
# Contour plot with default options
v <- contourPlot2(volcano3d)
v

# Set levels, and properly format the legend title:
contourPlot2(
    volcano3d,
    levels = c(-Inf, seq(100, 200, 20), Inf),
    legend = expression("PM"[10] ~ "[" * mu * "g m"^-3 * "]")
)

# Sometimes, instead of a contour plot it is better to plot the original
# raster data, without any interpolation:
contourPlot2(
    volcano3d,
    levels = c(-Inf, seq(100, 200, 20), Inf),
    tile = TRUE
)

# Since contourPlot2 returns a `ggplot2` object, you can add instructions as:
library(ggplot2)
v +
    ggtitle("Example volcano data") +
    labs(x = NULL, y = NULL)

}
