% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_namespace.R
\name{pretty_namespace}
\alias{pretty_namespace}
\title{Append namespace to functions in script}
\usage{
pretty_namespace(
  con = NULL,
  text = NULL,
  ask = TRUE,
  askenv = new.env(),
  force = NULL,
  ignore = NULL,
  overwrite = FALSE,
  sos = FALSE
)
}
\arguments{
\item{con}{character, path to file or directory that contains script, Default: NULL}

\item{text}{character, vector that contains script, Default: NULL}

\item{ask}{boolean, If TRUE then a \code{\link[utils]{menu}} will be created for the use to
choose between competing namespaces for a function, Default: TRUE}

\item{askenv}{environment, environment that stores names of functions to force in ask,
Default: new.env()}

\item{force}{list, named list of functions to force over the
internal search (seee details), Default: NULL}

\item{ignore}{list, named list of functions to ignore (seee details), Default: NULL}

\item{overwrite}{boolean, overwrite original file, Default: FALSE}

\item{sos}{boolean, apply sos search for uninstalled libraries, Default: FALSE}
}
\value{
character
}
\description{
Autoappend namespace to functions in script by searchpath order
}
\details{
Searches for functions in the \code{loadedNamespace}, \code{help.search} and then \code{\link[sos]{findFn}}.
If force is not NULL but a named list eg \code{list(stats=c('rnorm','runif'),utils = 'head')},
then the value pairs will be used in place of what was found using the search path.
If ignore is not NULL but a named list eg \code{list(stats=c('rnorm','runif'),utils = 'head')},
then if the functions are found they will not have a namespace attached to them.

If you want to toggle off the summary console printing you can set it globally via
\code{sinew_opts$set(pretty_print=FALSE)}.
}
\examples{
txt <- '#some comment
yy <- function(a=4){
  head(runif(10),a)
  # a comment
}

zz <- function(v=10,a=8){
  head(runif(v),a)
}'

pretty_namespace(text=txt)

}
\seealso{
\link[sos:findFn]{findFn}, \link[utils:help.search]{help.search}
}
\author{
Jonathan Sidi
}
\concept{namespace}
