% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\docType{data}
\name{sinew_opts}
\alias{sinew_opts}
\alias{sinew_opts_current}
\title{Default and current sinew options}
\format{
An object of class \code{list} of length 5.

An object of class \code{list} of length 5.
}
\usage{
sinew_opts

sinew_opts_current
}
\description{
Options for functions in the sinew package. When running R code, the object \code{sinew_opts}
(default options) is not modified by chunk headers (local chunk options are
merged with default options), whereas \code{sinew_opts_current} (current options)
changes with different chunk headers and it always reflects the options for
the current chunk.
}
\details{
Normally we set up the global options once in the first code chunk in a
document using \code{sinew_opts$set()}, so that all \emph{latter} chunks will
use these options. Note the global options set in one chunk will not affect
the options in this chunk itself, and that is why we often need to set global
options in a separate chunk.

A list of default chunk options, can be retrieved via
\code{sinew_opts$get()}
}
\note{
\code{sinew_opts_current} is read-only in the sense that it does nothing if
you call \code{sinew_opts_current$set()}; you can only query the options via
\code{sinew_opts_current$get()}.
}
\examples{
sinew_opts$get()
}
\concept{opts}
\keyword{datasets}
