% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_vcf}
\alias{ts_vcf}
\title{Save genotypes from the tree sequence as a VCF file}
\usage{
ts_vcf(
  ts,
  path,
  chrom = "chr1",
  individuals = NULL,
  position_transform = "lambda x: np.fmax(1, x)"
)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{path}{Path to a VCF file}

\item{chrom}{Chromosome name to be written in the CHROM column of the VCF
(default value will be "chr1").}

\item{individuals}{A vector of individuals in the tree sequence to extract
genotypes from. If missing, all individuals present in the tree sequence
will be saved. For a slendr-based tree sequence a character vector of
individual names is expected. For non-slendr tree sequences, a numeric
vector of IDs of individuals is expected.}

\item{position_transform}{How to transform coordinates in a tree sequence
to coordinates in a VCF file? By default, any site with coordinate 0
is converted to a position 1 to ensure that the resulting VCF file adheres
to the VCF specification. Setting this to \code{NULL} will disable this}
}
\value{
No return value, called for side effects
}
\description{
This function writes a VCF file with diploid genotypes from a given tree sequence.
}
\details{
Users should note that, as with many other tskit-based slendr functions,
\code{ts_vcf} is intended to provide some convenient defaults. For instance,
even for non-slendr tree sequences, it will name each individual in the
genotype columns after their integer IDs. In other words, if the
\code{individuals} function argument is given as \code{c(1, 42, 123)}, the
individuals will be named as "ind_1", "ind_42", and "ind_123", instead of
"tsk_0", "tsk_1", and "tsk_2". That said, the reticulate-based Python
interface of slendr allows calling the \code{write_vcf} function of tskit
directly!

By default, simulating a tree sequence with msprime and exporting the
genotypes into VCF can cause issues with some downstream software because
the VCF specification does not allow sites with the position 0. By default
\code{ts_vcf} automatically transforms a site with a zero coordinate to
a coordinate 1. Setting \code{position_transform} to NULL will disable
this, and \code{tsv_vcf} will save coordinates in their original form.
See this discussion for more detail:
\url{https://github.com/tskit-dev/tskit/issues/2838#issuecomment-1931796988},
as well as relevant topics in the tskit documentation on this issue, like
here: \url{https://tskit.dev/tskit/docs/latest/export.html#modifying-coordinates}.
}
