#' Insert query.
#'
#' This class represents an SQL SELECT query.
#' See the make_insert() factory function to create more easily an INSERT query
#' object.
#'
#' @examples
#' # To generate a simple INSERT query:
#' fields <- c('author', 'title', 'year')
#' insert <- StmtInsert$new(tabl = 'books', fields = make_fields(fields))
#' values <- make_rows(list(list('John Smith', 'Memories', 1999),
#'                          list('Barbara', 'My Life', 2010)))
#' insert <- QueryInsert$new(insert = insert, values = values)
#'
#' @seealso \code{\link{make_insert}}
#' @import R6
#' @include Query.R
#' @export
QueryInsert <- R6::R6Class("QueryInsert",
  inherit = Query,
  public = list(

    #' @description
    #' Initializer.
    #' @param insert A StmtInsert instance.
    #' @param values A StmtValues instance.
    #' @return Nothing.
    initialize = function(insert, values) {
      chk::chk_is(insert, "StmtInsert")
      chk::chk_is(values, "StmtValues")
      super$initialize(c("Insert", "Values"))
      self$add(insert)
      self$add(values)
      return(invisible(NULL))
    }
  )
)
