% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{transform_and_check}
\alias{transform_and_check}
\title{Transform a file an check the result}
\usage{
transform_and_check(
  in_item,
  out_item,
  in_name = in_item,
  out_name = out_item,
  transformer,
  dry,
  write_tree = FALSE,
  out_tree = "_tree",
  ...
)
}
\arguments{
\item{in_item}{An path to an file to transform.}

\item{out_item}{The path to a file that contains the expected result.}

\item{in_name}{The label of the in_item, defaults to \code{in_item}.}

\item{out_name}{The label of the out_item, defaults to \code{out_item}.}

\item{transformer}{A function to apply to the content of \code{in_item}.}

\item{dry}{To indicate whether styler should run in \emph{dry} mode, i.e. refrain
from writing back to files .\code{"on"} and \code{"fail"} both don't write back, the
latter returns an error if the input code is not identical to the result
of styling. "off", the default, writes back if the input and output of
styling are not identical.}

\item{write_tree}{Whether or not the tree structure of the test should be
computed and written to a files.}

\item{out_tree}{Name of tree file if written out.}

\item{...}{Parameters passed to transformer function.}
}
\description{
Transform an file and check whether it is identical to a reference.
}
\keyword{internal}
