% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sys_ggradar.R
\name{sys_ggradar}
\alias{sys_ggradar}
\title{This function is derived from the 'ggradar' package. \url{https://github.com/ricardo-bion/ggradar/}.}
\source{
Most of the code is from \url{http://rstudio-pubs-static.s3.amazonaws.com/5795_e6e6411731bb4f1b9cc7eb49499c2082.html}.
}
\usage{
sys_ggradar(
  plot.data,
  base.size = 15,
  font.radar = "sans",
  values.radar = c("0\%", "50\%", "100\%"),
  axis.labels = colnames(plot.data)[-1],
  grid.min = 0,
  grid.mid = 0.5,
  grid.max = 1,
  centre.y = grid.min - ((1/9) * (grid.max - grid.min)),
  plot.extent.x.sf = 1,
  plot.extent.y.sf = 1.2,
  x.centre.range = 0.02 * (grid.max - centre.y),
  label.centre.y = FALSE,
  grid.line.width = 0.5,
  gridline.min.linetype = "longdash",
  gridline.mid.linetype = "longdash",
  gridline.max.linetype = "longdash",
  gridline.min.colour = "grey",
  gridline.mid.colour = "#007A87",
  gridline.max.colour = "grey",
  grid.label.size = 6,
  gridline.label.offset = -0.1 * (grid.max - centre.y),
  label.gridline.min = TRUE,
  label.gridline.mid = TRUE,
  label.gridline.max = TRUE,
  axis.label.offset = 1.15,
  axis.label.size = 5,
  axis.line.colour = "grey",
  group.line.width = 1.5,
  group.point.size = 6,
  group.colours = NULL,
  background.circle.colour = "#D7D6D1",
  background.circle.transparency = 0.2,
  plot.legend = if (nrow(plot.data) > 1) TRUE else FALSE,
  legend.title = "",
  plot.title = "",
  legend.text.size = 14,
  legend.position = "left",
  fill = FALSE,
  fill.alpha = 0.5,
  draw.points = TRUE,
  point.alpha = 1,
  line.alpha = 1
)
}
\arguments{
\item{plot.data}{dataframe comprising one row per group}

\item{base.size}{text size}

\item{font.radar}{text font family}

\item{values.radar}{values to print at minimum, 'average', and maximum gridlines}

\item{axis.labels}{names of axis labels if other than column names supplied via plot.data}

\item{grid.min}{value at which mininum grid line is plotted}

\item{grid.mid}{value at which 'average' grid line is plotted}

\item{grid.max}{value at which maximum grid line is plotted}

\item{centre.y}{value of y at centre of plot}

\item{plot.extent.x.sf}{controls relative size of plot horizontally}

\item{plot.extent.y.sf}{controls relative size of plot vertically}

\item{x.centre.range}{controls axis label alignment}

\item{label.centre.y}{whether value of y at centre of plot should be labelled}

\item{grid.line.width}{width of gridline}

\item{gridline.min.linetype}{line type of minimum gridline}

\item{gridline.mid.linetype}{line type of 'average' gridline}

\item{gridline.max.linetype}{line type of maximum gridline}

\item{gridline.min.colour}{colour of minimum gridline}

\item{gridline.mid.colour}{colour of 'average' gridline}

\item{gridline.max.colour}{colour of maximum gridline}

\item{grid.label.size}{text size of gridline label}

\item{gridline.label.offset}{displacement to left/right of central vertical axis}

\item{label.gridline.min}{whether or not to label the mininum gridline}

\item{label.gridline.mid}{whether or not to label the 'mininum'average' gridline}

\item{label.gridline.max}{whether or not to label the maximum gridline}

\item{axis.label.offset}{vertical displacement of axis labels from maximum grid line, measured relative to circle diameter}

\item{axis.label.size}{text size of axis label}

\item{axis.line.colour}{colour of axis line}

\item{group.line.width}{line width of group}

\item{group.point.size}{point size of group}

\item{group.colours}{colour of group}

\item{background.circle.colour}{colour of background circle/radar}

\item{background.circle.transparency}{transparency of background circle/radar}

\item{plot.legend}{whether to include a plot legend}

\item{legend.title}{title of legend}

\item{plot.title}{title of radar plot}

\item{legend.text.size}{text size in legend}

\item{legend.position}{position of legend, valid values are "top", "right", "bottom", "left"}

\item{fill}{whether to fill polygons}

\item{fill.alpha}{if filling polygons, transparency values}

\item{draw.points}{whether to draw points}

\item{point.alpha}{alpha for points, can be a single value or vector}

\item{line.alpha}{alpha for lines, can be a single value or vector}
}
\value{
a ggplot object
}
\description{
This function is derived from the 'ggradar' package. \url{https://github.com/ricardo-bion/ggradar/}.
}
