% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{as.list.tdigest}
\alias{as.list.tdigest}
\alias{as_tdigest}
\title{Serialize a tdigest object to an R list or unserialize a serialized tdigest
list back into a tdigest object}
\usage{
\method{as.list}{tdigest}(x, ...)

as_tdigest(x)
}
\arguments{
\item{x}{a tdigest object or a tdigest_list object}

\item{...}{unused}
}
\description{
These functions make it possible to create & populate a tdigest, serialize it out,
read it in at a later time and continue populating it enabling compact
distribution accumulation & storage for large, "continuous" datasets.
}
\examples{
set.seed(1492)
x <- sample(0:100, 1000000, replace = TRUE)
td <- tdigest(x, 1000)
as_tdigest(as.list(td))
}
