% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import.R
\name{import_sensor}
\alias{import_sensor}
\title{Imports data associated with a list of sensors}
\usage{
import_sensor(list_sensor)
}
\arguments{
\item{list_sensor}{A character vector specifying the names of sensors to import data for.}
}
\value{
A dataframe containing the imported data.
}
\description{
Imports data associated with a given list of sensor names from .RData files contained in a data directory.
The main purpose of this function is to load the data saved with write update data.
}
\examples{
\dontrun{ # This example requires a valid API key
period <- as.Date(c('2022-01-01', '2022-12-31'))
write_update_data('RteVitre-06', period[1], period[2])
write_update_data('ParisArcEnCiel-05', period[1], period[2])
import_sensor(c('RteVitre-06', 'ParisArcEnCiel-05'))
}
}
