% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.R
\name{airline}
\alias{airline}
\title{Airline Model (SARIMA(0,1,1)x(0,1,1)s)}
\usage{
airline(z, bc = FALSE, sma = c("standard", "generalized", "factorized"), ...)
}
\arguments{
\item{z}{A \code{ts} object (must have frequency > 1).}

\item{bc}{Logical. If TRUE, applies Box-Cox (log) transformation.}

\item{sma}{Character. Specification for seasonal MA operator. Options are:
standard, generalized or factorized. See manual for more details.}

\item{...}{Additional arguments passed to \code{\link{um}}.}
}
\value{
A \code{um} object with airline model specification.
}
\description{
Creates a seasonal ARIMA model with the structure popularized by Box and
Jenkins using airline passenger data: (0,1,1)x(0,1,1)s.
}
\details{
This is a convenience function equivalent to: \code{um(z, bc = bc, i
= list(1, c(1, s)), ma = list(1, c(1, s)), ...)} where s = frequency(z).
}
\seealso{
\code{\link{um}}
}
