% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.tlm.R
\name{summary.tlm}
\alias{summary.tlm}
\alias{print.summary.tlm}
\title{Summarizing the Model Fitting}
\usage{
\method{summary}{tlm}(object, ...)

\method{print}{summary.tlm}(x, ...)
}
\arguments{
\item{object}{an object of class "\code{tlm}", an output of the \code{\link{tlm}}
function.}

\item{\dots}{additional arguments.}

\item{x}{an object of class "\code{summary.tlm}" (an output of \code{summary.tlm}).}
}
\value{
A list with class "\code{summary.tlm}" including the following items:
\describe{
\item{model}{the fitted model in the transformed space.}
\item{ypow}{the value of \code{ypow}.}
\item{xpow}{the value of \code{xpow}.}
\item{summary}{the summary of the fitted model provide by \code{summary.lm}
(for gaussian response) or \code{summary.glm} (otherwise).}
}
}
\description{
A \code{summary} method for an object created by the function \code{tlm}.
}
\details{
Essentially, the output of \code{\link{summary.lm}} or \code{\link{summary.glm}}
is displayed. In addition, further information on the fitted model is also
displayed.
}
\examples{
### linear model with log-log transformation:
data(feld1)
modcat <- tlm(logroom ~ logmattress + cat, data = feld1, ypow = 0, xpow = 0)
modcat
summary(modcat)
}
\references{
Barrera-Gomez J, Basagana X. Models with transformed variables:
interpretation and software. Epidemiology. 2015;26(2):e16-17.
}
\seealso{
\code{\link{tlm}}, \code{\link{effectInfo}}, \code{\link{MY}}.
}
