% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tlm.R
\name{tlm}
\alias{tlm}
\alias{print.tlm}
\alias{plot.tlm}
\title{Fitting, Reporting and Visualizing Linear, Logistic and Poisson
Regression Models with Transformed Variables}
\usage{
tlm(
  formula,
  family = gaussian,
  data,
  ypow = 1,
  xpow = 1,
  ...,
  y,
  x,
  z = "none"
)

\method{print}{tlm}(x, ...)

\method{plot}{tlm}(x, type = c("original", "transformed", "diagnosis"),
 observed = FALSE, xname = "x", yname = "y", level = 0.95, ...)
}
\arguments{
\item{formula}{model \code{\link{formula}}. Left-hand-side indicates the response
variable (whose values are assumed to be already transformed). First term in
right-hand-side indicates the explanatory variable of interest (whose values
are assumed to be already transformed). Right-hand-side can include additional
terms (e.g. adjusting variables) but the explanatory variable of interest
cannot be involved in any of them.}

\item{family}{the response variable \code{\link{family}}. Allowed values are: 1) \code{gaussian}
(default), for linear regression; 2) \code{binomial}, for logistic regression,
and 3) \code{poisson}, for Poisson regression with logarithmic link. Quoted
values are allowed.}

\item{data}{a \code{data.frame} containing the variables in the model.}

\item{ypow}{numeric. Power transformation already done in the response variable.
See Details below.}

\item{xpow}{numeric. Power transformation already done in the explanatory
variable of interest. See Details below.}

\item{\dots}{for \code{tlm}, additional arguments for the underlying \code{lm}
or \code{glm} fitting. For \code{print.tlm} and \code{plot.tlm}, additional
arguments for generic methods \code{print} and \code{plot}, respectively.}

\item{y, z}{old arguments for back compatibility only. To be removed, see
Details below.}

\item{x}{for \code{tlm}, old argument for back compatibility only. To be
removed, see Details below. For \code{print.tlm} and \code{plot.tlm}, an
object of class "\code{tlm}" (an output of the \code{tlm} function).}

\item{type}{For \code{plot.tlm}, character indicating the type of plot for
the fitted model. If "\code{original}" (default), the fitted model is plotted
in the original space of the variables. If "\code{diagnosis}", a model
diagnostics plot is shown. If "\code{transformed}", the fitted model is
plotted in the transformed space of the variables (where the model
has been fitted). Resulting plots under "\code{transformed}" should not be
reported (see Details below).}

\item{observed}{For \code{plot.tlm}, logical indicating whether the observations
are shown in the plot. Assumed to be \code{FALSE} if the explanatory variable
of interest is categorical. Default is \code{FALSE}.}

\item{xname, yname}{For \code{plot.tlm}, character indicating the name of the
explanatory and the response variable of interest for labeling the plot axes.
Default are "\code{x}" and "\code{y}", respectively.}

\item{level}{For \code{plot.tlm}, numeric indicating the confidence level for
the confidence of the expectation of the response variable according to the
fitted model. Default is 0.95.}
}
\value{
A list with class "\code{tlm}" including the following items:
\describe{
\item{model}{the fitted model in the transformed space.}
\item{ypow}{the value of \code{ypow}.}
\item{xpow}{the value of \code{xpow}.}
}
}
\description{
\code{tlm} is the main function of the package. It fits a linear,
logistic or Poisson regression model with transformed variables and creates
an object which can be subsequently used to compute adjusted measures of the
response variable (with \code{\link{MY}}) and compute and interpret adjusted
effects of the explanatory variable of interest on the response variable (with
\code{\link{effect}} and \code{\link{effectInfo}}, respectively), in the natural
scale of the variables. In addition, the fitted model can be visualized with
the \code{plot.tlm} method.
}
\details{
The transformations already done in the response variable and in the
explanatory variable of interest are passed by \code{ypow} and \code{xpow},
respectively, and must be numbers. Default is 1, meaning no transformation.
The value 0 corresponds to the logarithmic transformation. If \code{family}
is not \code{gaussian}, the response variable is assumed non transformed. If
the explanatory variable of interest is categorical or takes only two different
values, the value of \code{xpow} is assumed to be 1. If the explanatory
variable of interest takes only two different values, it is handled as a
binary variable.

Plots obtained for \code{type = "transformed"} are intended to visually explore
the model goodness of fit and should not be reported because values of the
transformed variables are meaningless (e.g. log(cotinine) has no sense).

Old arguments \code{y}, \code{x} and \code{z}, are deprecated and bugs are
no longer fixed. They will be removed in the first version posterior to 0.2.0.
Use argument \code{formula} instead.
}
\examples{
### Linear model with log-log transformation:
### effect of mattress levels on room levels, adjusting for cat:
# model fitting in the transformed space:
data(feld1)
head(feld1)
modcat <-  tlm(logroom ~ logmattress + cat, data = feld1, ypow = 0, xpow = 0)
modcat
summary(modcat)
# plot of the geometric mean of the response (original space), adjusting for 'cat':
plot(modcat, xname = "Mattress levels", yname = "room levels") 
# plot of the mean of the log of response (transformed space), adjusting for 'cat' and
# adding the observations:
plot(modcat, type = "transformed", xname = "mattress levels", yname = "room levels",
     observed = TRUE)
# diagnosis plot:
plot(modcat, type = "diagnosis")

### effect of cat in house on room levels, adjusting for matress levels:
modcat2 <-  tlm(logroom ~ cat + logmattress, data = feld1, ypow = 0)
summary(modcat2)
# plot of the geometric mean of the response (original space), adjusting
# for mattress levels:
plot(modcat2, xname = "Cat", yname = "room levels") 
# plot of the mean of the log of response (transformed space), adjusting
# for mattress levels:
plot(modcat2, type = "transformed", xname = "Cat", yname = "room levels")
}
\references{
Barrera-Gomez J, Basagana X. Models with transformed variables:
interpretation and software. \emph{Epidemiology}. 2015;26(2):e16-17.
}
\seealso{
\code{\link{MY}}, \code{\link{effect}}, \code{\link{formula}}.
}
