% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms-generics.R
\name{transform_random_affine}
\alias{transform_random_affine}
\title{Random affine transformation of the image keeping center invariant}
\usage{
transform_random_affine(
  img,
  degrees,
  translate = NULL,
  scale = NULL,
  shear = NULL,
  resample = 0,
  fillcolor = 0
)
}
\arguments{
\item{img}{A \code{magick-image}, \code{array} or \code{torch_tensor}.}

\item{degrees}{(sequence or float or int): Range of degrees to select from.
If degrees is a number instead of sequence like c(min, max), the range of
degrees will be (-degrees, +degrees).}

\item{translate}{(tuple, optional): tuple of maximum absolute fraction for
horizontal and vertical translations. For example \code{translate=c(a, b)}, then
horizontal shift is randomly sampled in the range
-img_width * a < dx < img_width * a and vertical shift is randomly sampled
in the range -img_height * b < dy < img_height * b. Will not translate by
default.}

\item{scale}{(tuple, optional): scaling factor interval, e.g c(a, b), then
scale is randomly sampled from the range a <= scale <= b. Will keep
original scale by default.}

\item{shear}{(sequence or float or int, optional): Range of degrees to select
from. If shear is a number, a shear parallel to the x axis in the range
(-shear, +shear) will be applied. Else if shear is a tuple or list of 2
values a shear parallel to the x axis in the range \verb{(shear[1], shear[2])}
will be applied. Else if shear is a tuple or list of 4 values, a x-axis
shear in \verb{(shear[1], shear[2])} and y-axis shear in \verb{(shear[3], shear[4])}
will be applied. Will not apply shear by default.}

\item{resample}{(int, optional): An optional resampling filter. See interpolation
modes.}

\item{fillcolor}{(tuple or int): Optional fill color (Tuple for RGB Image and
int for grayscale) for the area outside the transform in the output image
(Pillow>=5.0.0). This option is not supported for Tensor input. Fill value
for the area outside the transform in the output image is always 0.}
}
\description{
Random affine transformation of the image keeping center invariant
}
\seealso{
Other random_transforms: 
\code{\link{transform_color_jitter}()},
\code{\link{transform_random_crop}()},
\code{\link{transform_random_erasing}()},
\code{\link{transform_random_grayscale}()},
\code{\link{transform_random_horizontal_flip}()},
\code{\link{transform_random_perspective}()},
\code{\link{transform_random_resized_crop}()},
\code{\link{transform_random_rotation}()},
\code{\link{transform_random_vertical_flip}()}
}
\concept{random_transforms}
