% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_continuity_by_window.R
\encoding{UTF-8}
\name{check_continuity_by_window}
\alias{check_continuity_by_window}
\title{Check Time Series Continuity within Defined Window / Pruefung der Zeitreihen-Kontinuitaet}
\usage{
check_continuity_by_window(
  date_vec,
  years,
  months,
  window_unit = c("week", "day", "month"),
  step = 1,
  use_isoweek = FALSE,
  start_date = NULL,
  allow_leading_gap = FALSE
)
}
\arguments{
\item{date_vec}{A vector of dates. / Ein Datumsvektor}

\item{years}{Numeric vector indicating year range (e.g., c(2021, 2022)). / Jahr(e)}

\item{months}{Numeric vector of months (1:12). / Monate (1:12)}

\item{window_unit}{Time unit for continuity check: "day", "week", or "month". / Zeiteinheit fuer Pruefung}

\item{step}{Step size for the sequence. Default is 1. / Schrittweite}

\item{use_isoweek}{Logical. If TRUE, weeks start on Monday. / ISO-Woche (Montag)?}

\item{start_date}{Optional. Override default start date (must be in "YYYY-MM-DD" format). / Optionales Startdatum}

\item{allow_leading_gap}{Logical. If TRUE, allows first date to be missing but considers rest as continuous. / Erlaubt Anfangsluecke?}
}
\value{
A list with the following elements:
\describe{
  \item{continuous}{Logical. Whether the time series is complete}
  \item{gaps}{Data frame of missing expected dates}
  \item{datum}{Vector of available dates within the window}
  \item{range}{Start and end of expected time window}
}
}
\description{
This function checks whether a date vector contains all expected time points within a specified window.
Users can define the time unit (day, week, or month), granularity step, and whether ISO week starts (Monday) should be used.
Returns a list indicating whether the data are continuous and reports any missing dates.
}
\details{
Diese Funktion prueft, ob ein Datumsvektor alle erwarteten Zeitpunkte innerhalb eines definierten Fensters enthaelt.
Die Zeitgranularitaet (Tag/Woche/Monat), Schrittweite und ISO-Wochenstart (Montag) koennen angepasst werden.
Gibt zurueck, ob die Zeitreihe vollstaendig ist, und listet fehlende Zeitpunkte auf.
}
\examples{
vec <- seq(as.Date("2021-01-01"), as.Date("2021-03-31"), by = "day")
check_continuity_by_window(vec, years = 2021, months = 1:3, window_unit = "day")

}
