% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmp.R
\name{pmp_upper_bound}
\alias{pmp_upper_bound}
\title{Pan Matrix Profile upper bound}
\usage{
pmp_upper_bound(
  data,
  threshold = getOption("tsmp.pmp_ub", 0.95),
  refine_stepsize = getOption("tsmp.pmp_refine", 0.25),
  return_pmp = TRUE,
  n_workers = 1,
  verbose = getOption("tsmp.verbose", 2)
)
}
\arguments{
\item{data}{a \code{matrix} or a \code{vector} of \code{numeric}.}

\item{threshold}{a \code{numeric}. Correlation threshold. See details.  (Default is \code{0.95}).}

\item{refine_stepsize}{a \code{numeric}. Step size for the last upper bound search. See details.  (Default is \code{0.25}).}

\item{return_pmp}{a \code{logical}. If \code{TRUE}, returns the computed data as a \code{PMP} object, if \code{FALSE},
returns just the upper bound value. (Default is \code{TRUE}).}

\item{n_workers}{an \code{int}. Number of workers for parallel. (Default is \code{1}).}

\item{verbose}{verbose an \code{int}. See details. (Default is \code{2}).}
}
\value{
Returns a \code{PMP} object with computed data, or just the upper bound value if \code{return_pmp} is set to \code{FALSE}.
}
\description{
Finds the upper bound for Pan Matrix Profile calculation.
}
\details{
The Pan Matrix Profile may not give any further information beyond a certain window size. This function starts
computing the matrix profile for the window size of 8 and doubles it until the minimum correlation value found is
less than the \code{threshold}. After that, it begins to refine the upper bound using the \code{refine_stepsize} values, until
the \code{threshold} value is hit.

\code{verbose} changes how much information is printed by this function; \code{0} means nothing, \code{1} means text, \code{2}
adds the progress bar, \code{3} adds the finish sound.
}
\examples{
# return the object
pan_matrix <- pmp_upper_bound(mp_gait_data)

# just the upper bound
pan_ub <- pmp_upper_bound(mp_gait_data, return_pmp = FALSE)
}
\references{
\itemize{
\item Yet to be announced
}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
