% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visstat-methods.R
\name{plot.visstat}
\alias{plot.visstat}
\title{Report only saved plot files for visstat objects}
\usage{
\method{plot}{visstat}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"visstat"}, returned by \code{visstat()}.}

\item{...}{Currently unused. Included for S3 method compatibility.}
}
\value{
Invisibly returns \code{x}. Used for its side effect of reporting file paths.
}
\description{
This method reports the file paths of plots that were saved to disk during
the statistical analysis, if the user requested file output (e.g., PNG or PDF)
via the \code{graphicsoutput} argument.
}
\details{
Note that plots are shown during execution of \code{visstat()},
even if no files are saved. This method does not re-render or replay those plots.

All file-based plots in \code{visStatistics} are generated using the \code{Cairo()}
device and their file paths are collected in the object's \code{"plot_paths"} attribute.

In interactive sessions, this method prints the list of saved files.
In non-interactive contexts, it suppresses output.

The \code{visstat()} function may produce several plots per test type
(e.g., main effect, post hoc comparisons, assumption checks). These are saved to
disk, and their file paths are collected in the object's \code{"plot_paths"} attribute.

In an interactive session, \code{plot()} will print these paths to the console.
In non-interactive sessions, it quietly lists them. No plots are shown or rendered
within R.
}
\seealso{
\code{\link{visstat}}, \code{\link[Cairo]{Cairo}}, \code{\link{print.visstat}}, \code{\link{summary.visstat}}
}
