% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wordcloud2.R
\name{wordcloud2}
\alias{wordcloud2}
\title{Create wordcloud by wordcloud2.js}
\usage{
wordcloud2(data, size = 1, minSize = 0, gridSize =  0,
    fontFamily = 'Segoe UI', fontWeight = 'bold',
    color = 'random-dark', backgroundColor = "white",
    minRotation = -pi/4, maxRotation = pi/4, shuffle = TRUE,
    rotateRatio = 0.4, shape = 'circle', ellipticity = 0.65,
    widgetsize = NULL, figPath = NULL, hoverFunction = NULL)
}
\arguments{
\item{data}{A data frame including word and freq in each column}

\item{size}{Font size, default is 1. The larger size means the bigger word.}

\item{minSize}{A character string of the subtitle}

\item{gridSize}{Size of the grid in pixels for marking the availability of the canvas
the larger the grid size, the bigger the gap between words.}

\item{fontFamily}{Font to use.}

\item{fontWeight}{Font weight to use, e.g. normal, bold or 600}

\item{color}{color of the text, keyword 'random-dark' and 'random-light' can be used.
color vector is also supported in this param}

\item{backgroundColor}{Color of the background.}

\item{minRotation}{If the word should rotate, the minimum rotation
(in rad) the text should rotate.}

\item{maxRotation}{If the word should rotate, the maximum rotation (in rad) the text should rotate.
Set the two value equal to keep all text in one angle.}

\item{shuffle}{Shuffle the points to draw so the result will be different each time for the same list and settings.}

\item{rotateRatio}{Probability for the word to rotate. Set the number to 1 to always rotate.}

\item{shape}{The shape of the "cloud" to draw. Can be a keyword present. Available presents are 'circle'
(default), 'cardioid' (apple or heart shape curve, the most known polar equation),
'diamond' (alias of square), 'triangle-forward', 'triangle', 'pentagon', and 'star'.}

\item{ellipticity}{degree of "flatness" of the shape wordcloud2.js should draw.}

\item{widgetsize}{size of the widgets}

\item{figPath}{The path to a figure used as a mask.}

\item{hoverFunction}{Callback to call when the cursor enters or leaves a region occupied
by a word. A string of java script function.}
}
\description{
Function for Creating wordcloud by wordcloud2.js
}
\examples{
library(wordcloud2)
# Global variables can go here



wordcloud2(demoFreq)
wordcloud2(demoFreq, size = 2)

wordcloud2(demoFreq, size = 1,shape = 'pentagon')
wordcloud2(demoFreq, size = 1,shape = 'star')

wordcloud2(demoFreq, size = 2,
           color = "random-light", backgroundColor = "grey")

wordcloud2(demoFreq, size = 2, minRotation = -pi/2, maxRotation = -pi/2)
wordcloud2(demoFreq, size = 2, minRotation = -pi/6, maxRotation = -pi/6,
  rotateRatio = 1)
wordcloud2(demoFreq, size = 2, minRotation = -pi/6, maxRotation = pi/6,
  rotateRatio = 0.9)

wordcloud2(demoFreqC, size = 2,
           color = "random-light", backgroundColor = "grey")
wordcloud2(demoFreqC, size = 2, minRotation = -pi/6, maxRotation = -pi/6,
  rotateRatio = 1)

# Color Vector

colorVec = rep(c('red', 'skyblue'), length.out=nrow(demoFreq))
wordcloud2(demoFreq, color = colorVec, fontWeight = "bold")

wordcloud2(demoFreq,
  color = ifelse(demoFreq[, 2] > 20, 'red', 'skyblue'))
}

