
test_that("Yield generated from the NS model", {
  expect_equal(
    get_yield_at(seq(0.1, 1, by = 0.1), maturity = 1), 
    c(0.0337921613338867, 0.0322856630629355, 0.0309356840928623, 
      0.0296248349480087, 0.028235726152716, 0.0266509682313258, 0.0247531717081795, 
      0.0224249471076185, 0.0195489049539844, 0.0160076557716185)
  )
  expect_equal(
    get_yield_at(0.5, maturity = 1:30), 
    c(0.028235726152716, 0.0264140460005108, 0.0284880752513448, 
      0.0322700601268216, 0.0368614478397623, 0.0418617407732729, 0.047076723868982, 
      0.0524042928463304, 0.05778673674166, 0.0631893591805813, 0.0685902116114933, 
      0.0739748272422985, 0.0793333531974298, 0.0846589038639058, 0.0899465709700266, 
      0.0951928044184139, 0.100395011542717, 0.105551289928256, 0.110660244609415, 
      0.115720860117007, 0.120732409093486, 0.125694385841002, 0.130606457214064, 
      0.135468425797862, 0.140280201932223, 0.145041782199589, 0.149753232701087, 
      0.154414675923601, 0.159026280330983, 0.163588252043706)
  )
  expect_equal(
    generate_yield(), 
    sapply(
      seq_len(12)/12, 
      function(time) sapply(
        (1:36)/(36/10), 
        function(maturity) get_yield_at(
          time, maturity)))
  )
  
})
