% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array.R
\docType{methods}
\name{array-indexing}
\alias{array-indexing}
\alias{[.zarr_array}
\title{Extract or replace parts of a Zarr array}
\usage{
\method{[}{zarr_array}(x, ..., drop = TRUE)
}
\arguments{
\item{x}{A \code{zarr_array} object of which to extract or replace the data.}

\item{...}{Indices specifying elements to extract or replace. Indices are
numeric, empty (missing) or \code{NULL}. Numeric values are coerced to integer
or whole numbers. The number of indices has to agree with the
dimensionality of the array.}

\item{drop}{If \code{TRUE} (the default), degenerate dimensions are dropped, if
\code{FALSE} they are retained in the result.}
}
\value{
When extracting data, a vector, matrix or array, having dimensions as
specified in the indices. When replacing part of the Zarr array, returns
\code{x} invisibly.
}
\description{
These operators can be used to extract or replace data from an array by
indices. Normal R array selection rules apply. The only limitation is that
the indices have to be consecutive.
}
\examples{
x <- array(1:100, c(10, 10))
z <- as_zarr(x)
arr <- z[["/"]]
arr[3:5, 7:9]
}
