% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmate.R
\name{report_checkmate_assertions}
\alias{report_checkmate_assertions}
\title{Report collection of assertions}
\usage{
report_checkmate_assertions(
  collection,
  message = "Invalid input(s):",
  .envir = parent.frame()
)
}
\arguments{
\item{collection}{\verb{[AssertCollection]} A collection of assertions created
with \code{\link[checkmate:AssertCollection]{checkmate::makeAssertCollection()}}.}

\item{message}{\verb{[character(1)]} string with the header of the error message
if any assertions failed}

\item{.envir}{The \verb{[environment]} to use for the error message.
Default \code{parent.frame()} will be sufficient for most use cases.}
}
\value{
\code{invisible(TRUE)}
}
\description{
Improved reporting of an \code{AssertCollection} created with the
\code{\link[checkmate:AssertCollection]{checkmate::makeAssertCollection()}} using \code{\link[cli:cli_abort]{cli::cli_abort()}} instead of
\code{\link[checkmate:AssertCollection]{checkmate::reportAssertions()}} in order to provide a more
informative error message.

The function is intended to be used inside a function that performs
assertions on its input arguments.
}
\examples{
add_numbers <- function(a, b) {
  collection <- checkmate::makeAssertCollection()
  checkmate::assert_numeric(x = a, add = collection)
  checkmate::assert_numeric(x = b, add = collection)
  report_checkmate_assertions(collection)
  return(a + b)
}

add_numbers(1, 2)
try(add_numbers(1, "b"))
try(add_numbers("a", "b"))

}
