/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimp.h"
#include "core/gimpimage-undo.h"
#include "core/gimpimage.h"
#include "core/gimpparamspecs.h"
#include "plug-in/gimpplugin-cleanup.h"
#include "plug-in/gimpplugin.h"
#include "plug-in/gimppluginmanager.h"

#include "gimppdb.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static GimpValueArray *
image_undo_group_start_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPlugIn  *plug_in   = gimp->plug_in_manager->current_plug_in;
      const gchar *undo_desc = NULL;

      if (plug_in)
        {
          success = gimp_plug_in_cleanup_undo_group_start (plug_in, image);

          if (success)
            undo_desc = gimp_plug_in_get_undo_desc (plug_in);
        }

      if (success)
        gimp_image_undo_group_start (image, GIMP_UNDO_GROUP_MISC, undo_desc);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_undo_group_end_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in)
        success = gimp_plug_in_cleanup_undo_group_end (plug_in, image);

      if (success)
        gimp_image_undo_group_end (image);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_undo_is_enabled_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gboolean enabled = FALSE;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      enabled = gimp_image_undo_is_enabled (image);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), enabled);

  return return_vals;
}

static GimpValueArray *
image_undo_disable_invoker (GimpProcedure         *procedure,
                            Gimp                  *gimp,
                            GimpContext           *context,
                            GimpProgress          *progress,
                            const GimpValueArray  *args,
                            GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gboolean disabled = FALSE;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
    #if 0
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in)
        success = gimp_plug_in_cleanup_undo_disable (plug_in, image);
    #endif

      if (success)
        disabled = gimp_image_undo_disable (image);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), disabled);

  return return_vals;
}

static GimpValueArray *
image_undo_enable_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gboolean enabled = FALSE;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
    #if 0
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in)
        success = gimp_plug_in_cleanup_undo_enable (plug_in, image);
    #endif

      if (success)
        enabled = gimp_image_undo_enable (image);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), enabled);

  return return_vals;
}

static GimpValueArray *
image_undo_freeze_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gboolean frozen = FALSE;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
    #if 0
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in)
        success = gimp_plug_in_cleanup_undo_freeze (plug_in, image);
    #endif

      if (success)
        frozen = gimp_image_undo_freeze (image);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), frozen);

  return return_vals;
}

static GimpValueArray *
image_undo_thaw_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gboolean thawed = FALSE;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
    #if 0
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in)
        success = gimp_plug_in_cleanup_undo_thaw (plug_in, image);
    #endif

      if (success)
        thawed = gimp_image_undo_thaw (image);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), thawed);

  return return_vals;
}

void
register_image_undo_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-image-undo-group-start
   */
  procedure = gimp_procedure_new (image_undo_group_start_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-undo-group-start");
  gimp_procedure_set_static_help (procedure,
                                  "Starts a group undo.",
                                  "This function is used to start a group undo--necessary for logically combining two or more undo operations into a single operation. This call must be used in conjunction with a 'gimp-image-undo-group-end' call.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1997");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The ID of the image in which to open an undo group",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-undo-group-end
   */
  procedure = gimp_procedure_new (image_undo_group_end_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-undo-group-end");
  gimp_procedure_set_static_help (procedure,
                                  "Finish a group undo.",
                                  "This function must be called once for each 'gimp-image-undo-group-start' call that is made.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1997");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The ID of the image in which to close an undo group",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-undo-is-enabled
   */
  procedure = gimp_procedure_new (image_undo_is_enabled_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-undo-is-enabled");
  gimp_procedure_set_static_help (procedure,
                                  "Check if the image's undo stack is enabled.",
                                  "This procedure checks if the image's undo stack is currently enabled or disabled. This is useful when several plug-ins or scripts call each other and want to check if their caller has already used 'gimp-image-undo-disable' or 'gimp-image-undo-freeze'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Rapha\xc3\xabl Quinet <raphael@gimp.org>",
                                         "Rapha\xc3\xabl Quinet",
                                         "1999");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("enabled",
                                                         "enabled",
                                                         "TRUE if undo is enabled for this image",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-undo-disable
   */
  procedure = gimp_procedure_new (image_undo_disable_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-undo-disable");
  gimp_procedure_set_static_help (procedure,
                                  "Disable the image's undo stack.",
                                  "This procedure disables the image's undo stack, allowing subsequent operations to ignore their undo steps. This is generally called in conjunction with 'gimp-image-undo-enable' to temporarily disable an image undo stack. This is advantageous because saving undo steps can be time and memory intensive.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("disabled",
                                                         "disabled",
                                                         "TRUE if the image undo has been disabled",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-undo-enable
   */
  procedure = gimp_procedure_new (image_undo_enable_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-undo-enable");
  gimp_procedure_set_static_help (procedure,
                                  "Enable the image's undo stack.",
                                  "This procedure enables the image's undo stack, allowing subsequent operations to store their undo steps. This is generally called in conjunction with 'gimp-image-undo-disable' to temporarily disable an image undo stack.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("enabled",
                                                         "enabled",
                                                         "TRUE if the image undo has been enabled",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-undo-freeze
   */
  procedure = gimp_procedure_new (image_undo_freeze_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-undo-freeze");
  gimp_procedure_set_static_help (procedure,
                                  "Freeze the image's undo stack.",
                                  "This procedure freezes the image's undo stack, allowing subsequent operations to ignore their undo steps. This is generally called in conjunction with 'gimp-image-undo-thaw' to temporarily disable an image undo stack. This is advantageous because saving undo steps can be time and memory intensive. 'gimp-image-undo-freeze' / 'gimp-image-undo-thaw' and 'gimp-image-undo-disable' / 'gimp-image-undo-enable' differ in that the former does not free up all undo steps when undo is thawed, so is more suited to interactive in-situ previews. It is important in this case that the image is back to the same state it was frozen in before thawing, else 'undo' behavior is undefined.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Adam D. Moss",
                                         "Adam D. Moss",
                                         "1999");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("frozen",
                                                         "frozen",
                                                         "TRUE if the image undo has been frozen",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-undo-thaw
   */
  procedure = gimp_procedure_new (image_undo_thaw_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-undo-thaw");
  gimp_procedure_set_static_help (procedure,
                                  "Thaw the image's undo stack.",
                                  "This procedure thaws the image's undo stack, allowing subsequent operations to store their undo steps. This is generally called in conjunction with 'gimp-image-undo-freeze' to temporarily freeze an image undo stack. 'gimp-image-undo-thaw' does NOT free the undo stack as 'gimp-image-undo-enable' does, so is suited for situations where one wishes to leave the undo stack in the same state in which one found it despite non-destructively playing with the image in the meantime. An example would be in-situ plug-in previews. Balancing freezes and thaws and ensuring image consistency is the responsibility of the caller.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Adam D. Moss",
                                         "Adam D. Moss",
                                         "1999");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("thawed",
                                                         "thawed",
                                                         "TRUE if the image undo has been thawed",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
