/*
  SPDX-FileCopyrightText: 2025-2026 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/
#pragma once
#include "textautogeneratetext_export.h"
#include <QMap>
#include <QString>
class QDebug;
class QJsonObject;
namespace TextAutoGenerateText
{
class TextAutoGenerateManager;
/*!
 * \brief The TextAutoGenerateChatSettings class
 * \author Laurent Montel <montel@kde.org>
 */
class TEXTAUTOGENERATETEXT_EXPORT TextAutoGenerateChatSettings
{
public:
    struct TEXTAUTOGENERATETEXT_EXPORT PendingTypedInfo {
        QString text;
        int scrollbarPosition = -1;
        QList<QByteArray> tools;
        [[nodiscard]] bool isValid() const;
        [[nodiscard]] bool hasPendingMessageTyped() const;
        [[nodiscard]] static QJsonObject serialize(const PendingTypedInfo &url);
        [[nodiscard]] static PendingTypedInfo deserialize(const QJsonObject &o);
        [[nodiscard]] bool operator==(const PendingTypedInfo &other) const;
    };
    /*!
     */
    explicit TextAutoGenerateChatSettings(TextAutoGenerateManager *manager);
    /*!
     */
    ~TextAutoGenerateChatSettings();

    /*!
     */
    void remove(const QByteArray &chatId);

    /*!
     */
    void add(const QByteArray &chatId, const PendingTypedInfo &info);

    /*!
     */
    [[nodiscard]] PendingTypedInfo value(const QByteArray &chatId);

    /*!
     */
    [[nodiscard]] bool hasPendingMessageTyped(const QByteArray &chatId) const;

    /*!
     */
    [[nodiscard]] bool isEmpty() const;
    /*!
     */
    [[nodiscard]] int count() const;

    /*!
     */
    void loadRoomPendingTypedInfo();

private:
    TEXTAUTOGENERATETEXT_NO_EXPORT void setPendingTypedTexts(const QMap<QByteArray, TextAutoGenerateChatSettings::PendingTypedInfo> &newPendingTypedTexts);
    QMap<QByteArray /*ChatId*/, PendingTypedInfo> mPendingTypedTexts;
    TextAutoGenerateManager *const mManager;
};
}
TEXTAUTOGENERATETEXT_EXPORT QDebug operator<<(QDebug d, const TextAutoGenerateText::TextAutoGenerateChatSettings::PendingTypedInfo &t);
