---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, polices
---

# Comment mettre en évidence une portion de texte ?

Vous pouvez utiliser la commande `\emph`. 
Cette commande est définie dans la classe de votre document 
et sert spécifiquement à mettre en évidence un mot, une expression ou toute une phrase.

En temps normal, elle se contente de mettre en italique votre texte.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\noindent Ne jure pas, parce que tout serment est \emph{emphase}. \\[2ex]

\raggedleft
Jorge Luis \textsc{Borges}, \textit{Éloge de l'ombre} (1969).
\end{document}
```

Mais vous pouvez lui donner une nouvelle définition avec `\renewcommand`
(mettre en rouge, en gras...). Cette commande est décrite à la question
"[](/2_programmation/macros/commande_newcommand)".


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{xcolor}         % Gestion de la couleur
  \usepackage{xspace}

  % Rédéfinition de \emph
  \renewcommand{\emph}[1]{\textcolor{red}{#1}\xspace}

\begin{document}
\noindent Les plus grandes choses n'ont besoin que d'être dites simplement : 
elles se gâtent par \emph{l'emphase}. Il faut dire noblement les plus petites : 
elles ne se soutiennent que par l'expression, le ton et la manière. \\[2ex]

\raggedleft
Jean \textsc{de La Bruyère}, \textit{Les Caractères} (1696).
\end{document}
```

:::{seealso}
L'exemple ci-dessus utilise en particulier l'extension <ctanpkg:xspace> 
pour bien gérer les espacements après notre commande redéfinie. 
Ce sujet est détaillé à la question 
"[](/3_composition/texte/mots/une_commande_avale_l_espace_qui_la_suit)".
De même, il utilise l'extension <ctanpkg:xspace> pour gérer la couleur 
dans le texte, comme détaillé dans la question 
"[](/3_composition/texte/paragraphes/ecrire_du_texte_en_couleurs)".
:::