(syntax-tokens)=
# Syntaxe des jetons

Cette page sert de référence pour la syntaxe de MyST Markdown.

:::{seealso}
Pour plus de description et d'explication de la syntaxe de MyST, voir le [guide de syntaxe](/8_contribuer/syntaxe/syntax.md).
:::

## Jetons de bloc (multilignes)

Les jetons de bloc couvrent plusieurs lignes de contenu. Ils sont divisés en deux sections :

- {ref}`extended-block-tokens` contient des tokens *extra* qui ne sont pas dans CommonMark.
- {ref}`commonmark-block-tokens` contient des jetons CommonMark qui fonctionnent aussi, pour référence.

:::{note}
Parce que MyST markdown a été inspiré par des fonctionnalités qui existent dans reStructuredText,
nous avons indiqué ci-dessous la syntaxe équivalente de rST pour de nombreuses fonctionnalités de MyST markdown.
:::

(extended-block-tokens)=
### Jetons de blocs étendus

`````{list-table}
:header-rows: 1
:widths: 10 20 20
:class: longtable

* - Jeton
  - Description
  - Exemple
* - Entête
  - Un bloc YAML au début du document entouré de `---`
  - ```yaml
    ---
    ⟨clé⟩: ⟨valeur⟩
    ---
    ```
* - Directives
  - Encadrées par au moins 3 "*backticks*", suivis du nom de la directive
  entre accolades `{}`. Plus de détails [ici](https://myst-parser.readthedocs.io/en/latest/syntax/roles-and-directives.html).
  - ````md
    ```{⟨directive⟩}
    :⟨option⟩: ⟨valeur⟩

    ⟨Contenu⟩
    ```
    ````
* - Math
  - Mathématiques sur plusieurs lignes. Environnements LaTeX
  d’[amsmath](https://ctan.org/pkg/amsmath) possibles.  Plus de détails
  [ici](https://myst-parser.readthedocs.io/en/latest/syntax/optional.html#syntax-math).
  - ```{noedit}
    $$
    \mathrm{e}^{\mathrm{i}\pi}+1=0
    $$
    ```
* - Tableau
  - Style de tableau Markdown standard, avec séparation des colonnes par
  caractères "*pipe*" (`|`).
  - ```md
    | a | b |
    |:--|--:|
    | c | d |
    ```
* - Ligne commentée
  - Une ligne commentée. Voir <project:./syntax.md#commentaires> pour plus d'informations.
  - ```md
    % ceci est un commentaire
    ```
* - Coupures thématiques
  - Définit les blocs de texte. Voir <project:./syntax.md#coupures-thématiques>
  pour plus d'informations.
  - ```md
    +++ {"meta": "data"}
    ```
* - Note de bas de page
  - Définition d'une note de bas de page de référence, placée au bas du document.
   Plus de détails [ici](./syntax.md#notes-de-bas-de-page).
  - ```md
    [^ref] : Un texte de note de bas de page
    ```
* - Admonitions
  - Syntaxe alternative pour les admonitions (seulement).
  - ````md
    :::{note}
    ⟨Contenu⟩
    :::
    ````
* - "*Span*" HTML
  - Tout code HTML valide (rendu dans la sortie HTML uniquement)
  - ```html
    <p>Bla bla</p>
    ```
* - Échappement
  - Symboles échappés (non interprétés)
  - ```md
    \*
    ```
* - Liens automatiques
  - Liens apparaissant dans la sortie finale
  - ```md
    <https://ctan.org/>
    ```
* - Extraits de code
  - Texte restitué verbatim
  - ```md
    `a=1`
    ```
* - Coupure de ligne
  - Se terminant par un espace ou une barre oblique inverse
  - ```md
    Retour à la ligne\
    ```
* - Image
  - Lien vers une image.
    Plus de détails [ici](./syntax.md#images-et-figures)
  - ```md
    ![alt](src "title")
    ```
* - Lien
  - Voir <project:./syntax.md#références-croisées> pour plus de détails.
  - ```md
    [texte](cible "titre") ou [texte][clé]
    ```
* - Gras
  - Texte en gras
  - ```md
    **⟨texte en gras⟩**
    ```
* - Emphase
  - Texte en italique
  - ```md
    *⟨texte en emphase⟩*
    ```
* - Texte brut
  - Tout texte
  - ```md
    ⟨N'importe quel texte⟩
    ```
`````

(commonmark-block-tokens)=
### Jetons CommonMark

```{todo}
À compléter (cf. https://myst-parser.readthedocs.io/en/latest/syntax/reference.html#commonmark-block-tokens).
```
